<div class="min-h-[calc(100vh-152px)]">
    <?php
    $postid = filter_input(INPUT_GET, 'caixa_id', FILTER_VALIDATE_INT);
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Relatório dia</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Saldo inicial</h5>
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Valor</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $caixa = new Read;
                        $caixa->ExeRead(DB_CAIXA, " WHERE caixa_id = {$postid}");
                        foreach ($caixa->getResult() as $c) :
                            extract($c);
                        ?>
                            <tr>
                                <td><?= date('d/m/Y H:i', strtotime($caixa_data)); ?></td>
                                <td><?= number_format($caixa_valor, 2, ',', '.'); ?></td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <br />
    <br />

    <?php
    $sangrias = new Read;
    $sangrias->ExeRead(DB_SANGRIA, "WHERE sangria_caixa = {$postid}");
    ?>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Sangrias</h5>
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Valor</th>
                            <th>Obs</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sangriaTotal = 0;
                        if ($sangrias->getResult()) :
                            foreach ($sangrias->getResult() as $sangria) :
                                extract($sangria);
                                $sangriaTotal += $sangria_valor;
                        ?>
                                <tr>
                                    <td><?= date('d/m/Y H:i', strtotime($sangria_data)); ?></td>
                                    <td><?= number_format($sangria_valor, 2, ',', '.'); ?></td>
                                    <td><?= $sangria_obs; ?></td>
                                </tr>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php
    ?>
    <br />
    <br />
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Valores de conferência</h5>
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Pagamento</th>
                            <th>Valor sistema</th>
                            <th>Valor informado</th>
                            <th>Diferença</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $horarios = new Read;
                        $horarios->FullRead("SELECT caixa_data AS Data1, caixa_fechamento AS Data2 FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");

                        $data1 = $horarios->getResult()[0]['Data1'];
                        $data2 = $horarios->getResult()[0]['Data2'];

                        $data1n = date('Y-m-d', strtotime($data1));
                        $data1h = date('H:i:s', strtotime($data1));

                        $data2n = date('Y-m-d', strtotime($data2));
                        $data2h = date('H:i:s', strtotime($data2));

                        //Conta assinada
                        $cassinada = new Read;
                        $cassinada->FullRead("SELECT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE pagamento = 'Conta assinada' AND data BETWEEN '{$data1n}' AND '{$data2n}' AND time BETWEEN '{$data1h}' AND '{$data2h}' GROUP BY cod");

                        if ($cassinada->getResult()) :
                            $ca = $cassinada->getResult()[0]['Preco'];
                        else :
                            $ca = 0;
                        endif;

                        $cassinadai = new Read;
                        $cassinadai->FullRead("SELECT * FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");
                        $cai = $cassinadai->getResult()[0]['caixa_contaassinada'];

                        //Dinheiro
                        $dinheiro = new Read;
                        $dinheiro->FullRead("SELECT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE pagamento = 'Dinheiro' AND data BETWEEN '{$data1n}' AND '{$data2n}' AND time BETWEEN '{$data1h}' AND '{$data2h}'");

                        if ($dinheiro->getResult()) :
                            $di = $dinheiro->getResult()[0]['Preco'];
                        else :
                            $di = 0;
                        endif;

                        $dinheiroi = new Read;
                        $dinheiroi->FullRead("SELECT * FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");
                        $dii = $dinheiroi->getResult()[0]['caixa_dinheiro'];

                        //Pix
                        $pix = new Read;
                        $pix->FullRead("SELECT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE pagamento = 'PIX' AND data BETWEEN '{$data1n}' AND '{$data2n}' AND time BETWEEN '{$data1h}' AND '{$data2h}'");

                        if ($pix->getResult()) :
                            $pi = $pix->getResult()[0]['Preco'];
                        else :
                            $pi = 0;
                        endif;

                        $pixi = new Read;
                        $pixi->FullRead("SELECT * FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");
                        $pii = $pixi->getResult()[0]['caixa_pix'];

                        //Pagamento online
                        $pagamentoOnline = new Read;
                        $pagamentoOnline->FullRead("SELECT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE pagamento = 'Pagamento online' AND data BETWEEN '{$data1n}' AND '{$data2n}' AND time BETWEEN '{$data1h}' AND '{$data2h}'");

                        if ($pagamentoOnline->getResult()) :
                            $po = $pagamentoOnline->getResult()[0]['Preco'];
                        else :
                            $po = 0;
                        endif;

                        $pagamentoOnlinei = new Read;
                        $pagamentoOnlinei->FullRead("SELECT * FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");
                        $poi = $pagamentoOnlinei->getResult()[0]['caixa_pgonline'];

                        //Cartão de crédito
                        $cartaoCredito = new Read;
                        $cartaoCredito->FullRead("SELECT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE pagamento = 'Crédito' AND data BETWEEN '{$data1n}' AND '{$data2n}' AND time BETWEEN '{$data1h}' AND '{$data2h}'");

                        if ($cartaoCredito->getResult()) :
                            $cc = $cartaoCredito->getResult()[0]['Preco'];
                        else :
                            $cc = 0;
                        endif;

                        $cartaoCreditoi = new Read;
                        $cartaoCreditoi->FullRead("SELECT * FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");
                        $cci = $cartaoCreditoi->getResult()[0]['caixa_credito'];

                        //Cartão de débito
                        $cartaodeDebito = new Read;
                        $cartaodeDebito->FullRead("SELECT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE pagamento = 'Débito' AND data BETWEEN '{$data1n}' AND '{$data2n}' AND time BETWEEN '{$data1h}' AND '{$data2h}'");

                        if ($cartaodeDebito->getResult()) :
                            $cd = $cartaodeDebito->getResult()[0]['Preco'];
                        else :
                            $cd = 0;
                        endif;

                        $cartaodeDebitoi = new Read;
                        $cartaodeDebitoi->FullRead("SELECT * FROM " . DB_CAIXA . " WHERE caixa_id = {$postid}");
                        $cdi = $cartaodeDebitoi->getResult()[0]['caixa_debito'];

                        ?>
                        <tr>
                            <td>Conta assinada</td>
                            <td><?= number_format($ca, 2, ',', '.'); ?></td>
                            <td><?= number_format($cai, 2, ',', '.'); ?></td>
                            <td><?= number_format($cai - $ca, 2, ',', '.'); ?></td>
                        </tr>

                        <tr>
                            <td>Dinheiro</td>
                            <td><?= number_format($di, 2, ',', '.'); ?></td>
                            <td><?= number_format($dii, 2, ',', '.'); ?></td>
                            <td><?= number_format($dii - $di, 2, ',', '.'); ?></td>
                        </tr>

                        <tr>
                            <td>Pagamento online</td>
                            <td><?= number_format($po, 2, ',', '.'); ?></td>
                            <td><?= number_format($poi, 2, ',', '.'); ?></td>
                            <td><?= number_format($poi - $po, 2, ',', '.'); ?></td>
                        </tr>

                        <tr>
                            <td>Pix</td>
                            <td><?= number_format($pi, 2, ',', '.'); ?></td>
                            <td><?= number_format($pii, 2, ',', '.'); ?></td>
                            <td><?= number_format($pii - $pi, 2, ',', '.'); ?></td>
                        </tr>

                        <tr>
                            <td>Cartão de crédito</td>
                            <td><?= number_format($cc, 2, ',', '.'); ?></td>
                            <td><?= number_format($cci, 2, ',', '.'); ?></td>
                            <td><?= number_format($cci - $cc, 2, ',', '.'); ?></td>
                        </tr>

                        <tr>
                            <td>Cartão de débito</td>
                            <td><?= number_format($cd, 2, ',', '.'); ?></td>
                            <td><?= number_format($cdi, 2, ',', '.'); ?></td>
                            <td><?= number_format($cdi - $cd, 2, ',', '.'); ?></td>
                        </tr>

                        <tr>
                            <td><b>Total</b></td>
                            <td><?= number_format(($ca + $di + $po + $pi + $cc + $cd), 2, ',', '.'); ?></td>
                            <td><?= number_format(($cai + $dii + $poi + $pii + $cci + $cdi), 2, ',', '.'); ?></td>
                            <td>--</td>
                        </tr>

                        <tr>
                            <td><b>Abertura + Dinheiro - Sangria</b></td>
                            <td><?= number_format((($caixa_valor + $di) - $sangriaTotal), 2, ',', '.'); ?></td>
                            <td>--</td>
                            <td>--</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>