<div class="min-h-[calc(100vh-152px)]">
    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty) :
        WSErro("Ops: Você tentou editar um registro que não existe no sistema!", WS_INFOR);
    endif;

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)) :
        WSErro("O caixa foi aberto com sucesso no sistema!", WS_ACCEPT);
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Caixa</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Usuário</th>
                            <th>Dinheiro abertura</th>
                            <th>Dinheiro fechamento</th>
                            <th>Débito fechamento</th>
                            <th>Crédito fechamento</th>
                            <th>Pgto online fechamento</th>
                            <th>Pix fechamento</th>
                            <th>Contas assinadas fechamento</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $caixa = new Read;
                        $caixa->ExeRead(DB_CAIXA, " WHERE caixa_situacao = 0 ORDER BY caixa_data DESC");
                        foreach ($caixa->getResult() as $c) :
                            extract($c);
                        ?>
                            <tr>
                                <td><?= date('d/m/Y H:i', strtotime($caixa_data)); ?></td>
                                <td>
                                    <?php
                                    $usuario = new Read;
                                    $usuario->ExeRead(DB_USERS, " WHERE user_id = {$caixa_user}");
                                    $user = $usuario->getResult()[0]['user_name'];
                                    echo $user;
                                    ?>
                                </td>
                                <td><?= number_format($caixa_valor, 2, ',', '.'); ?></td>
                                <td><?= number_format($caixa_dinheiro, 2, ',', '.'); ?></td>
                                <td><?= number_format($caixa_debito, 2, ',', '.'); ?></td>
                                <td><?= number_format($caixa_credito, 2, ',', '.'); ?></td>
                                <td><?= number_format($caixa_pgonline, 2, ',', '.'); ?></td>
                                <td><?= number_format($caixa_pix, 2, ',', '.'); ?></td>
                                <td><?= number_format($caixa_contaassinada, 2, ',', '.'); ?></td>
                                <td><a href="painel.php?exe=financeiro/relatorio_caixa&caixa_id=<?= $caixa_id; ?>">Ver relatório</a></td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>