<div class="min-h-[calc(100vh-152px)]">
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Cadastrar categoria</h2>
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    if (isset($post) && $post['SendPostForm']):
        unset($post['SendPostForm']);

        require('_models/Categorias.class.php');
        $cadastra = new Categorias;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()):
            header('Location: painel.php?exe=produtos/new_index&createCategory=true&categoriaid=' . $cadastra->getResult());
        else:
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;
    ?>
    <br />
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Nome
                            da categoria</label>
                        <input type="text" class="form-input" name="nome" placeholder="Informe o nome da categoria"
                            value="<?php if (isset($post['nome']))
                                echo $post['nome']; ?>">
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit"
                        class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700"
                        value="Cadastrar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>